# Lightbox Plus Colorbox #  
Contributors: Programmattic LLC, dzappone
Donate link: http://www.23systems.net/plugins/donate/
Tags: lightbox, colorbox, jquery, jquery colorbox, photo, photos, image, images, video, ajax, gallery, lightview, picture, overlay, slideshow, content, forms, youtube, vimeo, nextgen
Requires at least: 4.0
Tested up to: 4.5.1
Stable tag: 2.8
License: GPLv2 and (components under MIT and BSD compatible licenses)
License URI: http://www.gnu.org/licenses/gpl-2.0.html

Lightbox Plus Colorbox creates beautiful overlays of larger images, simple slide shows, videos, and inline or external content.

## Description ##

Lightbox Plus Colorbox uses Colorbox to create beautiful image overlays in a lightbox for WordPress.  Lightbox Plus Colorbox displays larger versions of images to your users without having to leave the current page.  Lightbox Plus Colorbox is also capable of adding a lightbox to WordPress gallery images, NextGEN image galleries, displaying simple slide shows, displaying YouTube videos, Vimeo and other videos, and showing inline content such as forms and external content all in gorgeous overlay. The use of the dark or light background, which dims the page over which the lightbox has been overlaid, also serves to highlight the image, video, or content being displayed. Lightbox Plus Colorbox captures the image, link, or caption title for display in the lightbox.

Lightbox Plus Colorbox make use of the following tools: [Colorbox](http://www.jacklmoore.com/colorbox) was created by Jack Moore and is licensed under the [MIT License](http://www.opensource.org/licenses/mit-license.php).  Lightbox Plus Colorbox uses WordPress' built in jQuery library and also uses the [PHP Simple HTML DOM Parser](http://simplehtmldom.sourceforge.net/) helper class to navigate page content for inserting the Lightbox attributes into elements.

**ATTENTION:  Please update to version 2.8 as soon as possible to address Cross-Site Request Forgery (CSRF)/Cross-Site Scripting (XSS) Vulnerabilities in Lightbox Plus Colorbox versions 2.7.2 and earlier.**

### Release Notes ###

* Lightbox Plus Colorbox now requires PHP 5.3 or greater.
* Lightbox Plus Colorbox is undergoing a complete rewrite to improve performance and bring it in line with the latest WordPress coding standard.
* This will be released as with a new version matching the latest version of WordPress when released.
* Version 2.8 should be the last release before the update and we will only provide security updates to this version.
* See changelog for what's been updated.

### Troubleshooting ###

Please read the [FAQ](http://www.23systems.net/plugins/lightbox-plus/frequently-asked-questions/) first if you are having problems.

At present due to other commitments and that the plugin is provided freely we can offer no free support and it is provided as is.  There are plans for a support option in the works.

You can get community support for Lightbox Plus Colorbox via the [support forums](http://wordpress.org/support/plugin/lightbox-plus).

**Please do not contact Jack Moore the author of Colorbox for issues with Lightbox Plus Colorbox as he has nothing to do with the WordPress plugin.**

### Requirements ###

Server

* WordPress 4.0 (May work with earlier versions but you probably upgrade to the latest version anyway)
* PHP 5.3+
    * PHP 5.5+ recommended
    * Works with PHP 7.0.x
* jQuery (WordPress built in)

Support for PHP 4 has been completely removed asof version 2.1 - DO NOT UPDATE if you want Lightbox Plus Colorbox to work with PHP 4.

Client

* Modern Browsers
    * Firefox, Chrome, Safari, Opera, IE 10+, etc.
* Mobile Browsers
    * Firefox, Chrome, Safari, Opera, IE Mobile, etc.
* Legacy Browsers
    * IE 8, IE 9 (limited style support)

### Usage ###

Note that getting the caption to appear in the overlay image by using the caption options built into WordPress Lightbox Plus Colorbox uses the image title which is generated by "Edit Image Title" field and not the "Edit Caption Field."  You can also manually add lightbox tags to your images using the following instructions.

1. Add a rel="lightbox[uniqueID|filename]" attribute to any link tag to activate the lightbox, include a name between square brackets in the rel attribute. For example:

        <a href="images/image-1.jpg" rel="lightbox[uniqueID|filename]" title="my caption">image #1</a>

    Optional: Use the title attribute if you want to show a caption.

2. If you have a set of related images that you would like to group, follow step one but additionally include a group name between square brackets in the rel attribute. For example:

        <a href="images/image-1.jpg" rel="lightbox[roadtrip]">image #1</a>
        <a href="images/image-2.jpg" rel="lightbox[roadtrip]">image #2</a>
        <a href="images/image-3.jpg" rel="lightbox[roadtrip]">image #3</a>

## Installation ##

### Automatic ###

1. In the admin panel plugins page click Add New
2. Search for Lightbox Plus Colorbox
3. Find Lightbox Plus Colorbox in the list an click Install Now
4. Click OK when prompted
5. Click activate plugin when prompted
5. In the admin panel under Appearance click on Lightbox Plus Colorbox to configure to your taste.
6. Enjoy!

### Manual ###

1. Extract lightbox-plus.zip to your `wp-content/plugins` directory.
2. In the admin panel under plugins activate Lightbox Plus Colorbox.
3. In the admin panel under Appearance click on Lightbox Plus Colorbox to configure to your taste.
4. It should now be completely set up and functional
5. Enjoy!

### Caveats ###

Flash (i.e. YouTube videos, etc.) will sit atop the Lightbox Plus Colorbox display no matter what the z-index is.  This is an issue with Flash.

See [Flash content displays on top of all DHTML layers](http://go.adobe.com/kb/ts_tn_15523_en-us) at Adobe for details.

To work around this issue you will need to add something like the following to your`<param />` and `<embed></embed>` tags:

        <object><param name="wmode" value="opaque" /><embed wmode="opaque" [all other embed settings, file src etc.]></embed></object>

## Frequently Asked Questions ##

### Lightbox Plus Colorbox doesn't work ###

Well, yes, it probably does.  It's used by thousands of websites and if it doesn't work for you then it is likely because there is some problem with how it interacting with other JavaScript on your site.

The most common cause for it not working is a jQuery conflict cause by a theme or a plugin that either does not properly instantiate jQuery or instantiates a very old version of jQuery.

Here are things to try in order to see what the problem is.

1. Check jQuery version and make sure you are using the latest included in WordPress
 * If it's an older version or not enqueued correctly it will cause problems
 * It may be in your theme or another plugin
2. You may be lacking `wp_footer()` function in your `footer.php` of your WordPress theme.
 * Look at the default theme to see how it is implemented and add it into your theme.
3. Try deactivating all plugins one at a time besides lightbox plus and see if if it starts working
 * If it does work after deactivating on then there's a plugin conflict
4. If deactivating plugins doesn't work then there might be a conflict with your theme
 * To isolate you can try an different theme and see if it works
5. Try changing to a different lightbox style/theme and see if that makes a difference
 * There may be a style conflict of some sort
6. Try deleting the plugin and reinstalling - it may have not completely updated correctly.
 * You'll have to reset your settings so you might want to write them down.

### It works for some images and not others, why not? ###

The problem may be with your WordPress theme, mangling image display properties. Try using another theme, that doesn't interfere with posted images.

It also seems that some more recent version of WordPress (or perhaps the plugin is causing this in some way I am not aware of) do not automatically add the link to the full size image.  You must also make sure that when you are adding an image from the WordPress media dialog control you must make sure there is a link to the image in the Link URL field.  The easiest way to get the correct link is to click on the link to image button beneath the field.  [Visual depiction](http://www.23systems.net/wp-content/uploads/2008/07/file.png) of what is required when adding images in order for lightbox to function correctly.

### Lightbox Plus Colorbox doesn't work properly in browser X, Y, or Z (Chrome, Safari, Firefox, Opera, Explorer 6, 7, etc.)? ###

Yes it probably does, the problems may be the same as above or there may be a conflict with another plugin or a style conflict.  It has been tested in Chrome, IE 7+, Firefox 2+, Chrome, Safari 3+, Opera 8+ since development began.

### Does Lightbox Plus Colorbox work with PHP 4? If not, why not? ###

No it doesn't.  PHP 4 reached end of life on August 8th 2008 (about 8 years ago.)  WordPress no longer supports PHP 4 and all plugin developers are encourage to follow.  The best solution at this time is to ask your host provider to upgrade to PHP 5.

You will know that Lightbox Plus Colorbox is not working because of PHP if you receive the following error:

**Plugin couldn't be activated because of fatal error**

`Parse error: syntax error, unexpected T_OBJECT_OPERATOR in /path/to/plugin/classes/filters.class.php on line 81`

### Can I use this plugin and Lightview Plus, Lightbox 2 (either one), jQuery Colorbox, WP lightbox JS Plugin, Fancybox etc at the same time? ###

Maybe, but probably not as they will most likely interfere with each other as they usually modify the image URLs.  Other image overlay plugins may possibly be compatible.

### Can I add my own styles and images for the overlay? ###

Yes, you can easily create additional styles by checking the use custom styles checkbox.  It will copy the existing styles to `wp-content/lbp-css` and you can modify any of the existing styles.  You can all adding a new folder to that directory and using the existing styles as examples create your completely custom styles.

### How does Lightbox Plus Colorbox differ from other Lightbox plugins for WordPress? ###

Performance wise the Colorbox jQuery plugin is smaller and generally faster and has more options than most lightbox JavaScript plugins.  The regular expressions that handle the text are more robust handling a wider variety of characters and in addition it will also grab the image title from the image to use for the overlay image caption.

### Does Lightbox Plus Colorbox work with WordPress' built in gallery ###

Yes it does.  There are few simple requirements however.  You must set **Link thumbnails to: Image File** or use `[gallery link="file"` for the gallery options.  You must check *Use For WP Gallery* box under **Other Lightbox Plus Colorbox Settings**

### When resetting/re-initializing LBP the setting do not appear correctly when the page reloads, what gives? ###

This problem is only apparent in Chrome and Opera.  It seems to works fine in Internet Explorer, Firefox and Safari.  There are some browser related issues and I am investigating the problem at this time.  For Chrome the settings are being saved but not displayed immediately, click on the Lightbox Plus Colorbox link under appearance and you will see the current settings.  Opera for whatever reason is completely failing to save re-initialization settings, you must manually set and save them or use another browser.  And, no, it doesn't make sense since it's server side activity.

### Additional FAQs from Colorbox ###

For additional information please see [Colorbox FAQ](http://www.jacklmoore.com/colorbox/faq) for information about the jQuery plugin used by Lightbox Plus Colorbox.

### Other Problems ###

At present due to other commitments and that the plugin is provided freely we can offer no support and it is provided as is.

You can get community support for Lightbox Plus Colorbox via the [support forums](http://wordpress.org/support/plugin/lightbox-plus).

**Please do not contact Jack Moore the author of Colorbox for issues with Lightbox Plus Colorbox unless the issue is directly related to the JavaScript.**

### Known Problems ###

* Does not work correctly with W3 Total Cache if you are using automatic minify settings.  You can manually set up minify to work correctly bypassing Lightbox Plus Colorbox (jquery-colorbox.min.js)
* In some instances performance may be slow in older versions IE - this may be due to plugin conflicts or slow JavaScript performance in IE.
* Lightboxed video does not seem to work in IE on locally installed sites, for example viewing in IE 7.0 while running XAMPP, this seems to be a Windows only issue.

### Plugin Conflicts ###

* Jetpack Carousel - When carousel is activate it take precedence over Lightbox Plus Colorbox for image use as of LBP 2.x
* Flickr Mini Gallery - Verified.  Download [hot fix for Flickr Mini Gallery ](http://23systems.net/downloads/file/flickr-mini-gallery-jquery-hotfix.zip)(includes instructions) as of LBP 1.6.3
* Tabbed Widgets - Verified as of LBP 1.6.3
* DMSGuestbook - Un-verified as of LBP 1.6.3
* Gengo - Un-verified as of LBP 1.6.3

Note: Some of these conflicts were with very old versions of Lightbox Plus Colorbox and may be mitigated at this time

## Screenshots ##

1. Lightbox Plus Colorbox - Image
2. Lightbox Plus Colorbox - Video
3. Lightbox Plus Colorbox - External Content
4. Lightbox Plus Colorbox - Inline Content (Form)
5. Lightbox Plus Colorbox - Options Page
6. Lightbox Plus Colorbox - Style Examples

## Change Log ##

### 2.8 ###
* Validated against WordPress 4.5.x
    * Should use WordPress 4.0+ at a minimum.  4.5+ recommended
* PHP 5.3 or higher now required for plugin to function.
    * Should detect if older version os used and deactivate if that is the case
* Updated DOM parser to use QueryPath instead of Simple HTML DOM Parser
    * Uses PHP built in DOMDocument
    * Simple HTML Dom Parser removed
* Minified `lightbox.admin.css` to `lightbox.admin.min.css`.
* Added minification for inline JavaScript
* Added option to disable for mobile browsers
* Added option to make lightbox behave responsively depending on viewport size.
    * This predicates on the idea the user will not be switching platforms (i.e. you won't see it work in some test environments if switching from full size to mobile testing or you will see strange behavior when switching back to higher resolutions)
* Updated gallery lightbox code for newer versions of WordPress
* Added method to pull CDN hosted scripts and cache them instead of local scripts along with fallback option to local if CDN is unavailable.
    * All possible non-WordPress code scripts that are hosted by CDNs are now used by default.
* Fixed CSRF and XSS vulnerabilities as reported by [https://www.pluginvulnerabilities.com/2016/04/05/cross-site-request-forgery-csrfcross-site-scripting-xss-vulnerability-in-lightbox-plus-colorbox/]()
* Updated Colorbox to version 1.6.3 which includes the following fixes:
    * Fixed regression that caused error in IE8 when the calculated initial size was negative. Fixes 741
    * Fixed iframe attribute name (allowFullScreen to allowFullscreen). Fixes 737
    * Replaced the inline onclick handler for cboxPhoto with a namespaced event for easier unbinding. Fixes 719.
    * Added two new properties that expose how `<img>` and `<iframe>` elements are created, to give users direct control over those elements. Fixes 700.
    * Adding to NPM, merged white-space cleanup & new language file.
    * When opening, append Colorbox to the DOM if it was detached for whatever reason. Fixes 645.
    * Fixed regression introduced with v1.5.12 with legacy versions of jQuery (1.3x-1.6x). References 628.
    * Allowed setting the overlay opacity via CSS, by setting Colorbox's opacity property to false. References 628.
    * Fixed bug where setting opacity to 0 was ignored. Fixes 628.
    * Minor misc. tweaks (merging pull requests 611, 612, 615, 619, 620).
* Updated styles that had missing manual slideshow options
* Fixed bug that cause slideshows not to start sometimes
* Fixed using WP caption for lightbox caption in most case
    * This could still be an issue if the code is malformed in some way or the caption is out put differently
* Updated screenshots as they were looking a bit long in the tooth
* Updated inline help to always display next to option.
    * Added information about using with NextGEN Gallery.

### 2.7.2 ###
* Validated against WordPress 4.2.x
* Fixed minified files not being minified
* Fixed initialization error where initial settings were not being set making plugin seem to not work
* Minor bug fixes

### 2.7.1 ###
* Validated against WordPress 4.0-4.1.x
* Fixed minified files not being minified
* Temporary update prior to release of newly re-written version
* NOTE: some issue still persist in this version most obvious among them:
    * Initial settings not set up and must be manually entered and saved before plugin will display lightbox

### 2.7 ###
* Initial release of version 2.7
* Validated against WordPress 3.9.x
* Updated Colorbox to version 1.5.9 which includes the following fixes
    * Fixed inline content bug when using child selectors.  Fixes #599
    * Fixed accidental leak of global variable.  References #591
    * Enabled strict mode. Fixes #597
    * Fix potential error when calling Colorbox directly. References #591
    * Potentially worked around browser limitation of reporting that an image height and width is 0 immediately after onload.  Fixes #535
    * Applied maxWidth and maxHeight to the initialWidth and initialHeight.  Fixes #391
    * Allow setting the overlay opacity through CSS, rather than having to use Colorbox's opacity property.  Fixes #580
    * Fixed potential issue where IE9+ wouldn't close the modal when clicking on the overlay.  Fixes #576
    * Added access to settings object in callbacks.
    * Added svg to image types regex.
    * Fixed regression that broke direct calls to Colorbox, ie. $.colorbox(…)
    * Changed when the className is applied: immediately on open, but only updated immediately prior to transition.  Fixes #565
    * Fixed potential style flash if #cboxLoadedContent is given a background.  Fixes #567
    * Misc. code cleanup
    * Fixed potential error when resizing.  Fixes #254
    * Added Microsoft's JPEG XR to photo detection regex.
    * Fixed an issue where private events propagated to the document in versions of jQuery prior to 1.7.  Fixes #525, Fixes #526
    * Updated stylesheets to avoid issue with using `div {max-width:100%}` (Fixes #520)
    * Used setAttribute to set londesc, so that the value is accessible via DOM Node longDesc property #508
    * Added longdesc and aria-describedby attributes to photos.  Fixes #508
    * Fixed a slideshow regression from 1.4.27
    * Fixed a potential issue with the starting size of #cboxLoadedContent
    * Fixed a potential issue with using the open property with mixed slideshow and non-slideshow groups
    * Fixed a width calculation issue relating to using margin:auto on #cboxLoadedContent.
    * Fixed a regression in IE7 and IE8 that was causing an error.
    * Use an animation speed of zero between same-sized content (fixed).
    * Removed temporary fix for jQuery UI 1.8
    * Added closeButton option.  Set to false to remove the close button.
    * Bugfix loading overlay/graphic append order
    * Updated manifest files for the jQuery plugin repository and Bower (no changes to plugin)
    * Replaced new Image() with document.createElement('img') to avoid a potential bug in Chrome 27.
    * Fixing bug/typo from last update.
    * Fixed bug where Colorbox was capturing ctrl+click on assigned links on windows browsers with jQuery 1.7+, rather than ignoring.
    * Fixed a scroll position issue when using $.colorbox.resize()
    * Possible fix for a Chrome 27 issue (https://github.com/jackmoore/colorbox/pull/438#issuecomment-18334804)
    * Added trapFocus setting to allow disabling of focus trapping
    * Added .webp to list of recognized image extensions
    * Added fadeOut property to control the closing fadeOut speed.
    * Removed longdesc attribute for now.
    * Fixed an error involving IE7/IE8 and legacy versions of jQuery
    * Fixed a potential conflict with Twitter Bootstrap default img styles.
    * Added `type###'button'` to buttons to prevent accidental form submission
    * Added alt and longdesc attributes to photo content if they are present on the calling element.
    * Better 'old IE' feature detection that fixes an error with jQuery 2.0.0pre.
    * Fixes bug introduced in previous version.
    * Dropped IE6 support.
    * Fixed other issues with $.colorbox.remove.
    * Prevented an error if $.colorbox.remove is called during the transition.
    * Minor change to work around a jQuery 1.4.2 bug for legacy users.
    * Minor change to apply the close and className properties sooner.
    * Fixed an issue with percent-based heights in iOS
    * Fixed an issue with ajax requests being applied at the wrong time.
    * Made image preloading aware of retina settings.
    * Removed $.contains for compatibility with jQuery 1.3.x
    * Ignored left and right arrow keypresses if combined with the alt key.
    * Better accessibility:
    * Replaced div controls with buttons
    * Tabbed navigation confined to modal window
    * Added aria role
    * Updated manifest for plugins.jquery.com
    * Added retina display properties: retinaImage, retinaUrl, retinaSuffix
    * Fixed iframe scrolling on iOS devices.
* Update themes to work with correctly with Colorbox verison 1.5.9
    * Added styles to clean up borders around buttons in the lightbox

### 2.6 ###
* Added option to generate HTML5 valid code.  Checkbox under Base Settings -> Advanced.
    * When checked will add data- instead if rel attributes.
    * Can specify specify data- attribute so it can be site specific
    * Does not effect inline lightboxes which were class based already
    * Option located in first tab (General) of base settings
* Fixed (hopefully) all unset variable notices
    * Please notify me if you still seem them
* Fixed issues with per page loading
    * Please note there is no per post loading - it's either set for your blog/single posts or it's not
* Added option to load javascript in header or footer
    * Footer is preferred due to potential page load delays
* Added option to set priority of javascript loading
    * Low, Normal, High with priorities as follows 5, 11, 15 relative to other plugin loads
    * May resolve some plugin conflicts due to load order
* Fixed removal of settings on deactivate
    * Will now only remove settings on uninstall
* Fixed gallery short code issues with WordPress 3.0.x and version 3.1.x to 3.4.x.
    * Now creates correct gallery output for specific versions of WordPress
* Moved 'Use for WordPress Galleries' option to first tab to ease location
    * Located on General tab of Primary Settings
* Added Colorbox version loading newer/older depending on WordPress version
    * It seems older versions of WordPress were having jQuery conflict with the latest version of Colorbox
* Added information to submit for support under the support tab
* Fixed issue where PHP HTML DOM Parser would throw error when getting title if link had no child img to get title from.
* Renamed plugin to Lightbox Plus Colorbox to reflect long time usage or Colorbox as the lightbox tool
* Updated Colorbox to version 1.3.32
    * Improved internal event subscribing & fixed event bug introduced in v1.3.21
    * Fixed a size-calculation bug
    * Delayed border-width calculations until after opening, to avoid a bug in FF when using Colorbox in a hidden iframe.
    * Fixes bug with bubbling delegated events
    * Fixed compatibility issue with old versions of jQuery (1.3.2-1.4.2)
    * Added className property.
    * Minor bugfix: clear the onload event handler after photo has loaded.
    * Minor bugfix for calling Colorbox on empty jQuery collections without a selector.
* Minor internal fixes and changes

### 2.5.5 ###
* Fixed some issues when default jQuery of versions less than 1.4.3 (minimum required) were causing images to not load
* Fixed some jQuery methods in admin panel to work with versions of jQuery older than 1.6
* Updated Colorbox to version 1.3.21.1
    * Fixed global event issue for jQuery 1.9

### 2.5.4 ###
* Updated gallery shortcode replacement to match current implementation in WordPress
    * This was breaking galleries for some but not all people
* Updated styles to deal with the *"new"* CSS box model.
    * Thanks to hexagongirl for pointing this out to me
* Fixed problem where galleries where getting lighboxing treatment even if the Use for WP Galleries checkbox was unchecked.
    * You should now have to check the box for it to work
* Added a dozen new styles for a total of 26 different styles
    * Added style preview to admin panel to show a small screenshot of the style
* Updated FAQ in readme.txt

### 2.5.3 ###
* Changed support portal to use WordPress.org only as I am unable to handle multiple vectors for support
* Updated various links throughout plugin to reflect current URLs
* Updated instructions
* Miscellaneous minor bug fixes

### 2.5.2 ###
* Updated PHP Simple HTML DOM Parser to very latest rev (v 1.5 rev 202)
* Fixed PHP Simple HTML DOM Parser to create exception for servers that don't have mbstring extension enabled
    * This regressed with an update to recent versions of PHP Simple HTML DOM Parser
* Added support for up to 1000 inline lightboxes
    * Inline lightboxes are allocated in increments of 5
    * There is a performance hit in the Lightbox Plus admin when going over 100 however.

### 2.5.1 ###
* Fixed PHP Simple HTML DOM Parser functions that were throwing errors when using other plugins using PHP Simple HTML DOM Parser.

### 2.5 ###
* Added positioning options
    * Absolute top, right, bottom, left positioning.  Now able to specify horizontal and vertical position in viewport as opposed to center only.
    * Fixed positioning that allows lightbox stays on page when scrolled.
* Rebuilt interface
    * Changed interface to a combination of collapsible and tabbed to make it more concise and usable
    * Separate settings into logical groups within tabs
    * Added enhanced instructions and details of usage.
    * Improved and updated demos and tests.
* Page/Post Options
    * Auto launch on page.  If auto-launch is set Lightbox Plus will automatically open the first lightboxed item on the page.
    * Per page loading. If per page options are set Lightbox JavaScript will only load for specified pages.
    * Blog/posts only loading. if per page options are set Lightbox JavaScript will only load for specified pages.
* Image grouping
    * Added more control over image grouping
    * Fixed image X of X problem, can disable Image X of X
* Scrolling - If 'false' Colorbox will hide scrollbars for overflowing content. This could be used on conjunction with the resize method (see below) for a smoother transition if you are appending content to an already open instance of Colorbox.
* Numerous bug fixes
    * Fixed use WP Caption option.  Works with singles images and WordPress built in galleries now.
    * Fixed text links getting lightboxed even of option is not set.
    * Fixed many small issues and text errors.
* Added class check for php html dom classes to prevent stomping on other plugins using the class.
* Updated Colorbox to version 1.3.20
    * Added temporary workaround for jQuery-UI 1.8 bug (http://bugs.jquery.com/ticket/12273)
    * Added *.jpe extension to the list of image types.

### 2.4.6 ###
* Fixed PHP 5 comment bug that got reintroduced into plugin

### 2.4.5 ###
* Updated compatibility with WordPress 3.3
* Updated Colorbox to version 1.3.19
    * Fixed bug related to using the 'fixed' property.
    * Optimized the setup procedure to be more efficient.
    * Removed `$.colorbox.init()` as it will no longer be needed (will self-init when called).
    * Removed use of $.browser.
    * Fixed a regression where Flash content displayed in Colorbox would be reloaded if the browser window was resized.
    * Added safety check to make sure that Colorbox's markup is only added to the DOM a single time, even if $.colorbox.init() is called multiple times.  This will allow site owners to manually initialize Colorbox if they need it before the DOM has finished loading.
    * Updated the example index.html files to be HTML5 compliant.
    * Changed the slideshow behavior so that it immediately moves to the next slide when the slideshow is started.
    * Minor regex bug fix to allow automatic detection of image URLs that include fragments.

### 2.4 ###
* Removed all support for PHP 4.
    * If you still need a version that works with PHP 4 **DO NOT UPGRADE**
    * If you get this error: `Parse error: syntax error, unexpected T_OBJECT_OPERATOR in /path/to/plugin/classes/filters.class.php on line 81` you have PHP 4.
    * Contact your host provider to see if they can upgrade to PHP 5.
* Fixed issue where PHP Simple HTML DOM Parser was stripping returns causing issue with HTML output in several plugins (including SyntaxHighlighter Evolved)
    * This issue should be fairly rare.
* Patched PHP Simple HTML DOM Parser (`shd.class.php`) to verify `mb_detect_encoding()` function exist before calling
    * This issue was reported by several users that did not have mbstring functions compiled into PHP.
    * Assumes UTF-8 if function doesn't exist
    * The correct solution is to add the **mbstring** library to PHP (contact you host/support to resolve)

### 2.3.1 ###
* Changed wp_enqueue_script of jquery.colorbox-min.js to reduce chance of conflict with other implementations of Colorbox (should update for this reason)
* Updated PHP Simple HTML DOM Parser from version 1.1 to 1.5
    * Memory leak fixed!
    * Added support for detecting the source html character set.  This is used to convert characters when plaintext is requested.
    * Other little fixes and features, too numerous to categorize.
    * Error of "file_get_contents()" will be thrown as an exception.
    * Add flag: LOCK_EX while calling "file_put_contents()".
    * Fix the typo of "token_blank_t".
    * Supports xpath generated from Firebug.
    * New method "dump" of "simple_html_dom_node".
    * New attribute "xmltext" of "simple_html_dom_node".
    * remove preg_quote on selector match function: [attribute*###value];
    * Element "Comment" will treat as children.
    * Fixed the problem with <pre>.
    * Fixed bug #2207477 (does not load some pages properly).
    * Fixed bug #2315853 (Error with character after < sign).
* Cleaned up some general code and updated some help in the admin panel
* Updated demos as some were no longer pointing to working links
* Fixed typos in this file
* Updated the following styles: Dark, Elegant, Framed, Lightweight, and Shadowed

### 2.3 ###
* Tested with WordPress 3.2.x
* Minor bug fixes
* Some minor text fixes
* Added option to allow up to 100 inline lightboxes
* Updated Colorbox to version 1.3.17
    * Added properties "top", "bottom", "left" and "right" to specify a position relative to the viewport, rather than using the default centering.
    * Added property "data" to specify GET or POST data when using Ajax.  Colorbox's ajax functionality is handled by jQuery's .load() method, so the data property works the same way as it does with .load().
    * Added property "fixed" which can provide fixed positioning for Colorbox, rather than absolute positioning.  This will allow Colorbox to remain in a fixed position within the visitors viewport, despite scrolling.  IE6 support for this was not added, it will continue to use the default absolute positioning.
    * Fixed ClearType problem with IE7.
    * Minor fixes.
* Updated Colorbox to version 1.3.16
    * Better IE related transparency workarounds.  IE7 and up now uses the same background image sprite as other browsers.
    * Added error handling for broken image links. A message will be displayed telling the user that the image could not be loaded.
    * Added new property: 'fastIframe' and set it to true by default.  Setting to fastIframe:false will delay the loading graphic removal and onComplete event until iframe has completely loaded.
    * Ability to redefine $.colorbox.close (or prev, or next) at any time.

### 2.2.2 ###
* Corrected load_plugin_textdomain function calls, had incorrect number of arguments - Thanks Johannes!
* Minor interface corrections

### 2.2.1 ###
* Require HTML Parser only for PHP 5.X.  Was causing errors with PHP 4.X.
* Updated Colorbox to version 1.3.15
    * In IE6, closing an iframe when using HTTPS no longer generates a security warning.
    * Changed the index.html example files to use YouTube's new embedded link format.
    * By default, Colorbox returns focus to the element it was launched from once it closes.  This can now be disabled by setting the 'returnFocus' property to false.  Focus was causing problems for some users who had their anchor elements inside animated containers.
    * Minor bug fix involved in using a combination of slideshow and non-slideshow content.
    * Minor bug fix involved in preloading images when using a function as a value for the href property.
    * The slideshow now respects the loop property.
    * Fixed compatibility with jQuery 1.4.3
    * The 'open' property now accepts a function as a value, like all of the other properties.
    * Preloading now loads the correct href for images when using a dynamic (function) value for the href property.
    * Fixed bug in Safari 3 for Win where Colorbox centered on the document, rather than the visitor's viewport.
    * May have fixed an issue in Opera 10.6+ where Colorbox would rarely/randomly freeze up while switching between photos in a group.
    * Some functionality better encapsulated & minor performance improvements.

### 2.2 ###
* Fixed "Object id #", "Object", "Object #" errors with PHP 5.1.x.
    * Problem was due to circular memory leak in PHP 5.1 and 5.2 and HTML DOM object not being cleaned up.
    * Altered way the content is returned to allow for closure and cleaning of object sooner eliminating memory leak.
* Due to overwhelming demand I added PHP 4 functionality back in but it is not officially supported.
    * If you were seeing an error that looked something like `Parse error: syntax error, unexpected T_STRING, expecting T_OLD_FUNCTION or T_FUNCTION or T_VAR or '}' in /path/to/plugins/lightbox-plus/classes/shd.class.php on line 86` you have PHP 4.
    * Option is automatically set to use legacy method if you have PHP 4
    * You will have to manually select the option to use the *PHP 4 Auto Lightbox Method* if you are using PHP 5.X and wish to use legacy method.
* Fix for images with upper case file extension not being auto-lightboxed.
* Probable fix for `XML Parsing Error: no element found` likely caused by memory leak
    * Unable to reproduce error but research indicates memory leak is a likely cause.

### 2.1 ###
* Now requires PHP 5+, no PHP 4 support.
    * PHP4 reached its end of life on 8/8/2008 nearly 2 years ago.
* Fixed problems with initialization and re-initialization of the plugin not working under various circumstances.
    * Add code for activation/deactivation of the plugin
* Added true HTML parser instead of regular expressions
    * Using <a href="http://simplehtmldom.sourceforge.net/">PHP Simple HTML DOM Parser</a> for parsing HTML
    * Should mitigate issues of not consuming the HTML content and correctly modifying it
* Change method for finding and selecting styles
    * Added option for stylesheet directory to reside outside of plugin directory
    * Lightbox Plus no longer stores stylesheet path in options, it is now pulled from global definitions
    * It should now be easier to use on multiple servers with different paths.
* Added support for multiple galleries on a single page displaying separate slide shows
* Updated Colorbox to version 1.3.9
    * Fixed a bug in IE where iframed YouTube videos were not opening correctly.

### 2.0.5 ###
* Rewrote the way the plugin is instantiated.
    * Provide better control over how actions and filters are added by Lightbox Plus.
    * Provides fix for jQuery UI styles loading on all admin panels.
    * Prevented jquery.colorbox.min.js from loading on admin panels other than Lightbox Plus.
* Rewrote several functions to provide better compatibility with other plugins.
    * Admin scripts are now enqueued correctly.
    * Admin and plugin styles are now enqueued correctly.
* Fixed slideshow always auto-starting if slideshow enabled.
* Changed several variables and related fields
    * *Do Not Auto-Lightbox Images* using `auto_lightbox` to `no_auto_lightbox` to accurately reflect its use.
    * *Do Not Display Image Title* using `display_titles` to `no_display_titles` to accurately reflect its use.
    * *Use Class Method using* `class_method` to `use_class_method` to accurately reflect it's use.
    * If you use any of these settings you will need to re-check them and save your settings.
* Reduced size of inline JavaScript and converted all to jQuery.
    * Reduced size of some scripts using old toggle method for help.

### 2.0.2 ###
* Add quick fix/hack for a big interface issue on the admin panel. See roadmap for long term solution.
    * jQuery UI themes were overloading other plugins that were using the jQuery UI
    * Lightbox Plus specific themes and scripts should only load on Lightbox Plus panel
    * The exception is colorbox.min.js will load in any admin panel due to the way it is initialized. Expect version 2.0.5 to address this.

### 2.0.1 ###
* Fixed several interface issues in the admin panel.
    * User feedback was not reporting updates because admin scripts were not loading properly - this has been fixed.

### 2.0 ###
* Added secondary lightbox option
    * There is no auto-lightboxing for the secondary lightbox
    * Allows the creation of a secondary lightbox with iframe capabilities
    * Allows lightboxing of video, flash, and content that resides elsewhere
* Added inline lightbox options
    * There is no auto-lightboxing for the inline lightbox
    * Can have multiple inline lightboxes (up to 20)
    * Can be used to display hidden inline content, forms and more...
* Improved interface in admin panel.
    * Added better feedback for users
* Added backend test/demo areas
    * Allows user to test lightbox settings in the admin panel
    * Provides demos and examples for secondary lightbox using video, external webpages and interactive flash
    * Provides demos and examples for inline lightbox using inline content
* Fixed issue with saving setting and changes not being reflected.
* Updated Colorbox to version 1.3.8
    * Fixed a bug in Chrome where it would sometimes render photos at 0 by 0 width and height (behavior introduced in recent update to Chrome).
    * Fixed a bug where the onClosed callback would fire twice (only affected 1.3.7).
    * Fixed a bug in IE7 that existed with some iframed websites that use JS to reposition the viewport caused Colorbox to move out of position.
    * Abstracted the identifiers (HTML ids & classes, and JS plugin name, method, and events) so that the plugin can be easily rebranded.
    * Small changes to improve either code readability or compression.

### 1.7 ###
* Updated Colorbox to version 1.3.7
    * `$.colorbox` can now be used for direct calls and accessing public methods.  Example: `$.colorbox.close();`
    * Resize now accepts 'width', 'innerWidth', 'height' and 'innerHeight'. Example: `$.colorbox.resize({width:"100%"})`
    * Added option (loop:false) to disable looping in a group.
    * Added options (escKey:false, arrowKey:false) to disable esc-key and arrow-key bindings.
    * Added method for removing Colorbox from a document: $.colorbox.remove();
    * Fixed a bug where iframed URLs would be truncated if they contained an unencoded apostrophe.
    * Now uses the exact href specified on an anchor, rather than the version returned by 'this.href'. This was causing "#example" to be normalized to "http://domain/#example" which interfered with how some users were setting up links to inline content.

### 1.6.9.7 ###
* Fixed auto-lightbox breaking links that contained manually created `rel="lightbox[]"` attributes.

### 1.6.9.6 ###
* Skipping of auto-lightboxing of second image when image links were next to each other in html source should be fixed. At least in my testing.
* Fixed do not display image titles to work with text links.
    * Note - must already not have title tag in links elements.
* Fixed ability to use class method in text only links and gallery.
* Added ability to specify the class name used with class method.  Defaults to cboxModal for the class.
* Changed jQuery implementation of colorbox on the page to both reduce size and prepare for allowing two different colorboxes. (See Road Map)

### 1.6.9.5 ###
* No really, the IE problems should be resolved.
    * Correctly handle new settings when empty to render correct JavaScript on output - was causing IE to not display lightbox and weird sliding effect on lightbox in all browsers.
    * Fixed invalid function call that would prevent older versions of IE (7 or less) from rendering lightbox at all.
* Fixed issue that if admin was being accessed via SSL you could not save settings.
* Fixed some skipping of images being auto-lightboxed.  May not resolve all issues - please let me know at <href="http://www.23systems.net/bbpress/forum/lightbox-plus">Lightbox Plus Support</a>.

### 1.6.9 ###
* Fixed problem with styles in IE 6/7/8 not working under various circumstances (hopefully)
* Added the option to disable Lightbox Plus from adding its own styles allowing the user to place Lightbox/Colorbox styles in their theme stylesheet and reduce number of files loading.

### 1.6.8 ###
* Fixed duplicate `rel=lightbox[]` tags being generated.
* Fixed IE 6 specific stylesheets - should provide correct headers for php based css documents.
    * AlphaImageLoader should automatically be configure for old versions of IE - 6 or less
* As of this version IE 6 or less are no longer supported.
    * If you are using IE 6 or less it is recommended that you upgrade your browser.
* Added option to auto-lightbox text links to images
* Added additional width and height options
    * width - can set a fixed total width. This includes borders and buttons.
    * height    - can    set a fixed total height. This includes borders and buttons.
    * innerWidth - This is an alternative to 'width' used to set a fixed inner width. This excludes borders and buttons.
    * innerHeight - This is an alternative to 'height' used to set a fixed inner height. This excludes borders and buttons.
    * initialWidth    - can set the initial width, prior to any content being loaded.
    * initialHeight - can set the initial height, prior to any content being loaded.
* Updated `lightbox.admin.css` and `lightbox.admin.php` to correct a top level class that may effect global styles.
* Now works correctly with WordPress MU
    * Tested with WordPress MU 2.9.2
* Degradation of performance in Firefox corrected.  May still occur in older versions
    * Note: with the release of Firefox 3.0.19 the 3.0.x branch of Firefox will reach its end of life on March 30, 2010

### 1.6.7 ###
* Added fix to auto-lightbox images that are missing title attributes (Thanks J?rn)
    * This primarily affects images that were placed using older versions of WordPress
* Interface updates
    * Changed admin panel to work that same way as my other plugins and thereby ease code maintenance
    * Quick links in plugins list
    * Added additional support and FAQ links to admin panel
* Readme and FAQ update
* Actually includes Colorbox 1.3.6 which somehow was replaced by 1.3.1 in last release (1.6.6) for which I apologize.
* Includes `lightbox-plus.pot` for language translations for interested parties.

### 1.6.6 ###
* Tested with WordPress 2.9.1
    * Only works with WordPress 2.8+ due to the use of the `$in_footer` parameter used in the `wp_enqueue_script()` function.
* Moved all possible JavaScript to the footer to improve load speed
    * Requires theme has the `wp_footer()` hook
* Cleaned up jQuery call to correctly work in no conflict mode per definition.
* Updated Colorbox to 1.3.6 which include the following fixes
    * Small change to make Colorbox compatible with jQuery 1.4
    * Fixed a bug introduced in 1.3.4 with IE7's display of example 2 and example 3, and auto-width in Opera.
    * Fixed a bug introduced in 1.3.4 where colorbox could not be launched by triggering an element's click event through JavaScript.
    * Minor refinements.
    * Event delegation is now used for elements that Colorbox is assigned to, rather than individual click events.
    * Additional callbacks have been added to represent other stages of Colorbox's lifecycle. Available callbacks, in order of their execution: `onOpen`, `onLoad`, `onComplete`, `onCleanup`, `onClosed` These take place at the same time as the event hooks, but will be better suited than the hooks for targeting specific instances of Colorbox.
    * Ajax content is now immediately added to the DOM to be more compatible if that content contains script tags.
    * Focus is now returned to the calling element on closing.
    * Fixed a bug where `maxHeight` and `maxWidth` did not work for non-photo content.
    * Direct calls no longer need `'open:true'`, it is assumed.  Example: `$.fn.colorbox({html:"<p>Hi</p>"});`
    * Changed `$.fn.colorbox.element()` to return a jQuery object rather the DOM element.
    * jQuery.colorbox-min.js is compressed with Google's Closure Compiler rather than YUI Compressor.
    * Added `'innerWidth'` and `'innerHeight'` options to allow people to easily set the size dimensions for Colorbox, without having to anticipate the size of the borders and buttons.
    * Renamed `'scrollbars'` option to `'scrolling'` to be in keeping with the existing HTML attribute.  The option now also applies to iframes.
    * Bug fix: In Safari, positioning occasionally incorrect when using '100%' dimensions.
    * Bug fix: In IE6, the background overlay is briefly not full size when first viewing.
    * Bug fix: In Firefox, opening Colorbox causes a split second shift with a small minority of webpage layouts.
    * Simplified code in a few areas.
* Special thanks for navjotjsingh for the include, exclude fix for WordPress built in gallery

### 1.6.3 ###
* Eliminated conflict with Featured Content plug-in
    * Removed `jQuery.noConflict()` due to poor implementation on my part.
    * Kept `$lbp` jQuery variable.
* jQuery conflicts should all be resolved - hopefully.
* Minor modification to `wp_enqueue_script` function cal to include colorbox version.
* Now works with WordPress Mu if `rel=lightbox[]` is added manually.
    * Working on solving auto lightboxing issues with WordPress Mu

### 1.6.2 ###
* Added `jQuery.noConflict()` to the initiator to hopefully eliminate issues with other jQuery libraries loading and causing conflicts.
    * Changed jQuery `$` variable to `$lbp` to give a unique constructor.
* Added replacement shortcode gallery method to allow Lightbox Plus to work with shortcode galleries called via the `echo do_shortcode('[gallery link###"file" size###"thumbnail"]');` method in templates.
    * Replacement shortcode gallery function automatically adds `rel="lightbox"` or `class###"cboxModal"` as selected in options.
* Added code to automatically cleanup doubled title tags from shortcode galleries.
* Added quick links to the plugin listing on the plugin page.
* Some minor UI tweaks to the admin page.

### 1.6.1 ###
* Fixed IE display issues for elegant and shadowed themes.
    * Should now correctly grab path to images for IE 6/7/8
* Re-added additional simple styles blue, green, grey, purple, red, teal, yellow in addition to black and white
     * Fixed prev/next buttons in simple styles to only display when cursor hovers over left or right of image.

### 1.6 ###
* Added the much requested feature for Lightbox Plus to work with WordPress' built in gallery
    * Added checkbox to select whether to use with WP built in gallery.
* Updated Lightbox Plus to use new version of Colorbox
* Updated Colorbox to version 1.3.1 with the following changes
     * Removed the IE-only stylesheets and conditional comments.  All CSS is handled by a single CSS file for all examples.
     * Removed user-agent sniffing from the js and replaced it with feature detection.  This will allow correct rendering for visitors masking their agent type.
     * Added `$.fn.colorbox.resize()` method to allow Colorbox to resize it's height if it's contents change.
     * Added `scrollbars` option to allow users to turn off scrollbars when using the `resize()` method.
     * Renamed the `resize` option to be less ambiguous.  It's now `scalePhotos`.
     * Renamed the `cbox_close` event to be less ambiguous.  It's now `cbox_cleanup`.  It is the first thing to happen in the close method while the 'cbox_closed' event is the last to happen.
     * Fixed a bug with the slideshow mouseover graphics that appeared after Colorbox is opened a 2nd time.
     * Fixed a bug where Clear Type may not work in IE 6 & 7 if using the fade transition.
     * Minor code optimizations to increase compression.
* Minor corrections to admin interface.

### 1.5.5 ###
* Updated additional code that didn't make it into 1.5.4 to use less memory and run faster
* Separated the admin panel output to a separate file
    * Added some custom admin panel styles
    * Cosmetic changes to admin panel

### 1.5.4 ###
* Fixed bug where titles were being broken when DO NOT USE TITLE was checked.
* Fixed issue with limited character sets - should allow any characters in the title (diacritics, umlauts, etc.)
* Optimized code to use less memory and run faster
* Updated Colorbox to version 1.2.9
* No new features at this time

### 1.5.3.1 ###
* Fixed bug causing plugin not to use correct stylesheet on initial install or reset. It was pointing to a non-existent style (shadow instead of shadowed.)

### 1.5.3 ###
* Added class based option.
    * If options is checked, Lightbox Plus will only lightbox images via class: cpModal attribute.
    * Using this method you can manually control which images are affected by Lightbox Plus by adding the cpModal class the image link URL and checking the Don't Auto-Lightbox Images option.
* Added option to not automatically add attributes required for Lightbox Plus to work.  This allows for more manual image control.
* Added option not to display image titles.
* Updated Colorbox to version 1.2.5

### 1.5.2 ###
* Reset/re-initialize button on the plugin page will now remove the old files that were not removed during upgrade to 1.5.x from pre 1.5 versions.
* Fixed the slideshow timing to display and save correctly - any amount of time over 5000 milliseconds was displaying as 13000 milliseconds.
* Miscellaneous cosmetic fixes and text adjustments

### 1.5.1 ###
* Fixed the need to have `class###"imagebox"` added to image links

### 1.5 ###
* Rebuilt Lightbox Plus to utilize Colorbox for its image overlay functions
    * Supports photos, photo groups, slideshow, ajax, inline, and iframed content.
    * Appearance is completely controlled through CSS so users can restyle the box.
    * Written in jQuery plugin format and can be chained with other jQuery commands.
    * Generates W3C valid XHTML and CSS, adds no JS global variables & passes JSLint.
* **README!** - If you are upgrading from a previous version you will need to reset your Lightbox Plus settings as they have all changed and the old values are no longer useful.
* **README!** - There is a reset button that will remove your old options and replace them with the new options, Lightbox Plus will act funny until you either reset it or update the settings.
* **README!** - If you have custom styles back them up before proceeding.  You will need to convert them to the new directory and Colorbox format to use them again.
* **README!** - Only the black and white existing styles have been ported to the new format, it is very easy to convert any of the other color styles to the new format.
* Added reset button to allow for resetting to default settings.
* Tested In: Firefox 2, 3, Safari 3, 4, Opera 9, 10, Chrome 1, 2, Internet Explorer 6, 7, 8.

### 1.4 ###
* There is no version 1.4

### 1.3.4 ###
* Updated to work with WordPress 2.8

### 1.3.3 ###
* Fixed another problem with JavaScript error causing script not to work correctly.

### 1.3.2 ###
* Fixed problem with JavaScript error on IE7.
* Added some additional color styles.

### 1.3.1 ###
* Updated lightbox.js to allow better control from the admin panel - lightbox was failing sometimes due to duplicate JavaScript.

### 1.3.0 ###
* Added ability to configure Lightbox options from the admin panel
* Initializes base options on load
* Modified and rewrote code for better readability and functionality

### 1.1.1 ###
* Moved admin panel under Design/Appearance
* Minor code formatting for better readability

### 1.1.0 ###
* Fixed absolute pathing - should now work in blog residing in subdirectories
* Rolled code into class structure

### 1.0.1 ###
* Modifications to regular expression usage for image linking

### 1.0 ###
* Initial release

## Upgrade Notice ##

### 2.8 ###
* Please update to version 2.8 as soon as possible to address Cross-Site Request Forgery (CSRF)/Cross-Site Scripting (XSS) Vulnerabilities in Lightbox Plus Colorbox versions 2.7.2 and earlier.

## Special Thanks ##

* Dirk Schmitz (for pointing out an obvious bug that I kept overlooking)
* [Michael Sheehan](http://www.hightechdad.com/) and [Helena Hult&eacute;n](http://www.funnybunny.se/) for continued support and testing.
* Ken Williams (for testing version 1.5)
* Bart Lauwers of [GenThree](http://www.genthree.com/)
* navjotsingh (for bug fix in gallery shortcode with version 1.6.x)
* [Milan Petrovic](http://www.dev4press.com/) for some quick debugging of version 2.0 admin panel
* [Melanie Sallis](http://www.melaniesallis.com) for needing a lightbox for her site which prompted me to create this plugin
* [Jack Moore](http://www.jacklmoore.com/colorbox) for creating the awesome jQuery plugin, Colorbox, and everyone who has contributed to the support in developing this plugin.

## More Information ##

[Visit plugin site](http://www.23systems.net/plugins/lightbox-plus/) | [FAQ](http://www.23systems.net/wordpress-plugins/lightbox-plus-for-wordpress/frequently-asked-questions/) | [Community Support](http://wordpress.org/support/plugin/lightbox-plus) | [Follow on Twitter](http://twitter.com/23systems) | [Add Facebook Page](http://www.facebook.com/23Systems)
